<?php
require_once("../admin.php");
require_once("../session.php");

// Collect and validate inputs
$account_number = trim($_POST['account_number']);
$withdraw_amount = floatval($_POST['withdraw_amount']);
$trans_pin = trim($_POST['trans_pin']);
$naration = trim($_POST['naration']);
$teller_number = trim($_POST['teller_number']);
$date_withdraw = date('Y-m-d H:i:s');

// Fetch user details
$stmt = $conn->prepare("SELECT first_name, middle_name, last_name, balance, withdraw, trans_pin FROM register WHERE account_number = ?");
$stmt->bind_param("s", $account_number);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    $db_balance = $row['balance'];
    $db_withdraw = $row['withdraw'];
    $db_trans_pin = $row['trans_pin'];
    $account_name = $row['first_name'] . " " . $row['middle_name'] . " " . $row['last_name'];

    $new_balance = $db_balance - $withdraw_amount;
    $new_withdraw = $db_withdraw + $withdraw_amount;

    // Validate PIN and Balance
    if ($db_trans_pin !== $trans_pin && $db_balance < $withdraw_amount) {
        echo "<script>alert('WRONG TRANSACTION PIN AND INSUFFICIENT FUNDS'); window.location='post_ticket2.php';</script>";
        exit;
    }
    if ($db_trans_pin !== $trans_pin) {
        echo "<script>alert('WRONG TRANSACTION PIN'); window.location='post_ticket2.php';</script>";
        exit;
    }
    if ($db_balance < $withdraw_amount) {
        echo "<script>alert('INSUFFICIENT FUNDS'); window.location='post_ticket2.php';</script>";
        exit;
    }

    // Record withdrawal
    $stmt2 = $conn->prepare("INSERT INTO withdraw (withdraw_id, date_withdraw, teller_number, account_number, account_name, available_balance, withdraw_amount, naration, created_at)
                             VALUES (NULL, ?, ?, ?, ?, ?, ?, ?, NOW())");
    $stmt2->bind_param("ssssdds", $date_withdraw, $teller_number, $account_number, $account_name, $db_balance, $withdraw_amount, $naration);
    $stmt2->execute();

    // Update balances
    $stmt3 = $conn->prepare("UPDATE register SET balance = ?, withdraw = ? WHERE account_number = ?");
    $stmt3->bind_param("dds", $new_balance, $new_withdraw, $account_number);
    $stmt3->execute();

    echo "<script>alert('WITHDRAWAL SUCCESSFUL'); window.location='home.php';</script>";
} else {
    echo "<script>alert('ACCOUNT NOT FOUND'); window.location='post_ticket2.php';</script>";
}
?>
