<?php
require_once("admin.php");
require_once("insertpix.php");

error_reporting(E_ALL);
ini_set('display_errors', 1);


// Hash password before storing
$hashedPassword = password_hash($password, PASSWORD_DEFAULT);
$birthdate = "$day/$month/$year";

// Check for duplicates safely
$check = $conn->prepare("SELECT * FROM register WHERE email = ? OR phone_number = ?");
$check->bind_param("ss", $email, $phone_number);
$check->execute();
$result = $check->get_result();

if ($result->num_rows > 0) {
    echo "<script>alert('Email or phone number already exists!'); window.location='index.php';</script>";
    exit;
}

if ($password !== $re_password) {
    echo "<script>alert('Passwords do not match!'); window.location='index.php';</script>";
    exit;
}

// Prepare secure insert
$stmt = $conn->prepare("
    INSERT INTO register (
        account_type, first_name, middle_name, last_name, pix, date, gender, marital_status,
        zip_code, account_number, trans_pin, password, country, state, occupation,
        phone_number, email, address, home_phone_number, account_status,open_by,save,withdraw,balance,date_open	

    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'ACTIVE', 'CLIENT', '0.00', '0.00', '0.00', NOW())
");
$stmt->bind_param(
    "sssssssssssssssssss",
    $account_type, $first_name, $middle_name, $last_name, $f, $birthdate, $gender,
    $marital_status, $zip_code, $account_number, $trans_pin,$password, $country,
    $state, $occupation, $phone_number, $email, $address, $home_phone_number
);

if ($stmt->execute()) {
    // Update related tables
    $conn->query("UPDATE account_number SET status='USED' WHERE acct_number='$account_number'");
    $conn->query("UPDATE trans_pin SET status='USED' WHERE pin='$trans_pin'");

    // Send safe email (confirmation only)
    $to = $email;
    $subject = "Welcome to Gtruserve";
    $message = "
    <html>
    <body>
    <p>Dear $first_name,</p>
    <p>Welcome to <strong>Gtruserve</strong>! Your registration was successful.</p>
    <p>Please log in to your account to view your details securely.</p>
    <p><a href='https://www.gtruserve.com/login'>Login Here</a></p>
    </body>
    </html>
    ";
    $headers = "MIME-Version: 1.0\r\n";
    $headers .= "Content-type:text/html;charset=UTF-8\r\n";
    $headers .= "From: info@Gtruserve.com\r\n";

    mail($to, $subject, $message, $headers);

    echo "<script>alert('Registration successful! Please check your email.'); window.location='index.php';</script>";
} else {
    echo "<script>alert('Error creating account: " . $stmt->error . "');</script>";
}

$stmt->close();
$conn->close();


?>
